using gov.va.med.vbecs.Common;
using System;
using System.Linq;

namespace gov.va.med.vbecs.BOL
{
    /// <summary>
    /// PendingBloolUnitAntigenTypingModel
    /// </summary>
    public class PendingBloodUnitAntigenTypingModel : PendingTestModel, IPendingBloodUnitTestModel
    {
        /// <summary>
        /// BloodUnitGuid
        /// </summary>
        public Guid? BloodUnitGuid { get; set; }
        /// <summary>
        /// BloodUnitId
        /// </summary>
        public string BloodUnitId { get; set; }
        /// <summary>
        /// BloodUnitModel
        /// </summary>
        public BloodUnitModel BloodUnitModel { get; set; }
        /// <summary>
        /// OrderedTestGuid
        /// </summary>
        public Guid? OrderedTestGuid { get; set; }
        /// <summary>
        /// OrderedComponentGuid
        /// </summary>
        public Guid? OrderedComponentGuid { get; set; }   
        /// <summary>
        /// CheckCell
        /// </summary>
        public PendingTestResultModel CheckCell
        {
            get
            {
                return GetPendingTestResult(TestType.Anti_Dc_AHG, false);
            }
        }
        /// <summary>
        /// Result
        /// </summary>
        public PendingTestResultModel Result
        {
            get
            {
                return TestResultList.FirstOrDefault(x => !x.IsInterp && x.TestType != TestType.Anti_Dc_AHG);
            }
        }
        /// <summary>
        /// Interp
        /// </summary>
        public PendingTestResultModel Interp
        {
            get
            {
                return TestResultList.FirstOrDefault(x => x.IsInterp);
            }
        }
        /// <summary>
        /// UnitResultSetGuid
        /// </summary>
        public Guid ResultSetGuid { get; set; }
        /// <summary>
        /// InterpText
        /// </summary>
        public override string InterpText
        {
            get
            {
                if (Interp != null)
                {
                    return Interp.TestResultId;
                }

                return "";
            }
        }
        /// <summary>
        /// WorkloadProcessID
        /// </summary>
        public override WorkloadProcessID WorkloadProcessId
        {
            get
            {
                return WorkloadProcessID.AutomatedUnitAntigenTyping;
            }
        }

        /// <summary>
        /// Validate Test
        /// </summary>
        public TestValidationModel Validate(BloodUnitModel bloodUnitModel)
        {
            if (OrderableTest.IsWeakD)
            {
                return BOL.TestValidation.ValidateUnitWeakD(
                            Result == null ? string.Empty : Result.TestResultId,
                            CheckCell == null ? string.Empty : CheckCell.TestResultId,
                            Interp == null ? string.Empty : Interp.TestResultId,
                            bloodUnitModel == null ? null : (Guid?)bloodUnitModel.BloodUnitGuid,
                            ((int)OrderableTest.OrderableTestId).ToString(),
                            bloodUnitModel == null ? "" : bloodUnitModel.UnitRh,
                            bloodUnitModel == null ? UnitStatusCode.Unknown : bloodUnitModel.UnitStatusCode);
            }
            else
            {
                return BOL.TestValidation.ValidateUnitAntigentyping(
                            Result == null ? string.Empty : Result.TestResultId,
                            Interp == null ? string.Empty : Interp.TestResultId,
                            bloodUnitModel == null ? null : (Guid?)bloodUnitModel.BloodUnitGuid,
                            ((int)OrderableTest.OrderableTestId).ToString(),
                            bloodUnitModel == null ? UnitStatusCode.Unknown : bloodUnitModel.UnitStatusCode);
            }
        }
    }
}



